--this has a function for creating emitter bullets
require('g_level')

function create_emitter_bullet(path_list,is_repeating,speed,layer) --list of path points, is_repeating
    local bullet_sound_radius = 550.0
    local bullet_sound = "data/music/Tulipallo1.ogg"
    local bullet_speed = speed
    local dmg_start_script = "data/scripts/test/srt_start_damage_test.lua"
    local dmg_end_script = "data/scripts/test/srt_stop_damage_test.lua"
    local bullet_trigger_radius = 30.0
    
    
    local from_x = path_list[1][1]
    local from_y = path_list[1][2]
    local bullet_id = g_level.give_id()
    --bullet starts
    lua:create_bullet( "bullet", bullet_id )            -- shooter id, bullet id -- lets just create bullet to our shooter, little stupid but anyway
    --bullet trigger
    lua:create_circle( "bullet_shape", 0, 0, bullet_trigger_radius)         --shape with, 1 = shape with number of verticies, 5 = number of verticies

    lua:create_trigger( "bullet_trigger", TT_GATE, dmg_start_script,dmg_end_script, from_x,from_y)  --name, type, on_enter_script, on_leave_scipt,x,y  -- x and y should be very close to real start location
    lua:trigger_shape(  "bullet_trigger", TT_GATE, "bullet_shape")                --name, type, shape_name
    lua:trigger_add_group_i_belong_to( "bullet_trigger", TT_GATE, "everything") --name, type, group_name
    lua:trigger_add_group_can_use_me(  "bullet_trigger", TT_GATE, "player")     --name, type, group_name

    lua:trigger_set_color(  "bullet_trigger", 1.0, 0.0, 0.0, 0.5);              --trigger name, red, green, blue, alpha
    lua:bullet_set_trigger( "bullet", "bullet_trigger" );                       --shooter id, trigger name

    --Bullet graphics
    --create the particle
    lua:create_sprite("prototype", ST_PARTICLE, "myParticle", from_x,from_y)  --the translation values can be anything. They must be there for integrity but they ain't used to anything.
    lua:sprite_shape("prototype", ST_PARTICLE, 10.0,10.0)
    lua:textured_sprite_tex_coords("prototype", ST_PARTICLE, 0.0, 0.0, 1.0, 1.0)
    lua:particle_start_color("prototype", 0.7, 0.4, 0.3, 0.9) -- name: rgba-colors
    lua:particle_end_color("prototype", 0.0, 0.0, 0.0, 0.0)

    -- create the emitter
    lua:create_sprite("emitter", ST_EMITTER, "prototype", from_x,from_y) -- the translation values are on, the "texture" is the teztured particle inserted.
    lua:emitter_range("emitter", 0.75, 1.5, -5.0, 5.0, 25.0, 75.0)  --life min & max, angular_velocity min & max, linear_velocity min & max
    lua:emitter_scale("emitter", true, 1.0, 3.0, 2.0, 6.0)  -- variable_scale, begin_scale_range min & max, end_scale_range min & max
    lua:emitter_particle_amount("emitter", 55) -- target layer index
    lua:emitter_angle("emitter", 3.14) -- angle. (0-PI)
    --lua:emitter_timer_delay("emitter", 0.007) -- the new timer delay

    lua:remorfable_sprite("bullet_sprite", "emitter", bullet_speed, is_repeating)             -- name, sprite_name, speed, repeat
    
    for i=1, #path_list ,1  do
        local tmp_list = path_list[i]
        lua:add_key_frame(tmp_list[3], tmp_list[1], tmp_list[2], 0.0, 1.0)  -- adds a new key frame. time, x, y, rotation, scale
        lua:add_key_frame_color(1.0,1.0,1.0,1.0)  -- r,g,b,a
        lua:upload_key_frame("bullet_sprite")
    end

    --Bullet Graphics end
    lua:bullet_set_graphics("bullet", "bullet_sprite") -- shooter id, sprite
    lua:gameobject_remove_from_temp_list( "bullet_sprite" )

    --Bullet audio
    lua:create_sound("bullet_flying_sound", bullet_sound, bullet_sound_radius, from_x, from_y)  -- name, music_name, radius ( x and y will be replaced at first update  but good to have real place )
    lua:create_sound_effect("bullet_flying_sound", "bullet_flying_sound", 2.2, true)            -- object name, sound name, delay, loop
    lua:bullet_set_flying_sound("bullet", "bullet_flying_sound")                              -- shooter id, flying sound
    lua:gameobject_remove_from_temp_list( "bullet_flying_sound" )
    --bullet ends
    
    g_level.upload("bullet",layer)
end

function create_super_emitter_bullet(path_list,is_repeating,speed,layer) --list of path points, is_repeating
    local bullet_sound_radius = 350.0
    local bullet_sound = "data/music/Tulipallo2.ogg"
    local bullet_speed = speed
    local dmg_start_script = "data/scripts/dmg/srt_start_dmg300.lua"
    local dmg_end_script = "data/scripts/dmg/srt_stop_dmg300.lua"
    local bullet_trigger_radius = 30.0
    
    
    local from_x = path_list[1][1]
    local from_y = path_list[1][2]
    local bullet_id = g_level.give_id()
    --bullet starts
    lua:create_bullet( "bullet", bullet_id )            -- shooter id, bullet id -- lets just create bullet to our shooter, little stupid but anyway
    --bullet trigger
    lua:create_circle( "bullet_shape", 0, 0, bullet_trigger_radius)         --shape with, 1 = shape with number of verticies, 5 = number of verticies

    lua:create_trigger( "bullet_trigger", TT_GATE, dmg_start_script,dmg_end_script, from_x,from_y)  --name, type, on_enter_script, on_leave_scipt,x,y  -- x and y should be very close to real start location
    lua:trigger_shape(  "bullet_trigger", TT_GATE, "bullet_shape")                --name, type, shape_name
    lua:trigger_add_group_i_belong_to( "bullet_trigger", TT_GATE, "everything") --name, type, group_name
    lua:trigger_add_group_can_use_me(  "bullet_trigger", TT_GATE, "player")     --name, type, group_name

    lua:trigger_set_color(  "bullet_trigger", 1.0, 0.0, 0.0, 0.5);              --trigger name, red, green, blue, alpha
    lua:bullet_set_trigger( "bullet", "bullet_trigger" );                       --shooter id, trigger name

    --Bullet graphics
    --create the particle
    lua:create_sprite("prototype", ST_PARTICLE, "myParticle", from_x,from_y)  --the translation values can be anything. They must be there for integrity but they ain't used to anything.
    lua:sprite_shape("prototype", ST_PARTICLE, 10.0,10.0)
    lua:textured_sprite_tex_coords("prototype", ST_PARTICLE, 0.0, 0.0, 1.0, 1.0)
    lua:particle_start_color("prototype", 0.7, 0.4, 0.3, 0.9) -- name: rgba-colors
    lua:particle_end_color("prototype", 0.0, 0.0, 0.0, 0.0)

    -- create the emitter
    lua:create_sprite("emitter", ST_EMITTER, "prototype", from_x,from_y) -- the translation values are on, the "texture" is the teztured particle inserted.
    lua:emitter_range("emitter", 0.75, 1.5, -5.0, 5.0, 25.0, 75.0)  --life min & max, angular_velocity min & max, linear_velocity min & max
    lua:emitter_scale("emitter", true, 1.0, 3.0, 10.0, 20.0)  -- variable_scale, begin_scale_range min & max, end_scale_range min & max
    lua:emitter_particle_amount("emitter", 55) -- target layer index
    lua:emitter_angle("emitter", 3.14) -- angle. (0-PI)
    --lua:emitter_timer_delay("emitter", 0.007) -- the new timer delay

    lua:remorfable_sprite("bullet_sprite", "emitter", bullet_speed, is_repeating)             -- name, sprite_name, speed, repeat
    
    for i=1, #path_list ,1  do
        local tmp_list = path_list[i]
        lua:add_key_frame(tmp_list[3], tmp_list[1], tmp_list[2], 0.0, 1.0)  -- adds a new key frame. time, x, y, rotation, scale
        lua:add_key_frame_color(1.0,1.0,1.0,1.0)  -- r,g,b,a
        lua:upload_key_frame("bullet_sprite")
    end

    --Bullet Graphics end
    lua:bullet_set_graphics("bullet", "bullet_sprite") -- shooter id, sprite
    lua:gameobject_remove_from_temp_list( "bullet_sprite" )

    --Bullet audio
    lua:create_sound("bullet_flying_sound", bullet_sound, bullet_sound_radius, from_x, from_y)  -- name, music_name, radius ( x and y will be replaced at first update  but good to have real place )
    lua:create_sound_effect("bullet_flying_sound", "bullet_flying_sound", 0.1, true)            -- object name, sound name, delay, loop
    lua:bullet_set_flying_sound("bullet", "bullet_flying_sound")                              -- shooter id, flying sound
    lua:gameobject_remove_from_temp_list( "bullet_flying_sound" )
    --bullet ends
    
    g_level.upload("bullet",layer)
end

--LOAD GRAPHICS
lua_init_texture("myParticle", "data/images/myParticle.png", FM_NEAREST,WM_CLAMP,WM_CLAMP,AM_MODULATE)